unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, LibXmlParser, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TreeView: TTreeView;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
VAR
  XP            : TXmlParser;
  FrankfurtNode : TTreeNode;
begin
  XP := TXmlParser.Create;
  FrankfurtNode := NIL;
  TRY
    XP.LoadFromFile ('C:\CD-Collection.xml');
    XP.StartScan;
    WHILE XP.Scan DO
      CASE XP.CurPartType OF
        ptStartTag : FrankfurtNode := TreeView.Items.AddChild (FrankfurtNode, XP.CurName);
        ptEndtag   : FrankfurtNode := FrankfurtNode.Parent;
        ptContent  : FrankfurtNode.Text := FrankfurtNode.Text + '  - ' + XP.CurContent;
        END;
  FINALLY
    FreeAndNil (XP);
    END;
end;

end.
